<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBExperience 4.0                                                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006-2010 tabeeb-jarrah. All Rights Reserved.           # ||
|| #################################################################### ||
\*======================================================================*/

function GetPromotionEntry($promotion, $BFBo, $data, $oldusergrouparray, $IsLastGroup)
{
	global $vbulletin, $vbphrase;
	
	$promotion_overview = array();
	
	$promotion_overview['ingroup'] = false;
	if (is_member_of($vbulletin->userinfo, $promotion['usergroupid']))
	{
		$promotion_overview['ingroup'] = true;
	}

	//print_r($promotion);
	$groupcountsq = $vbulletin->db->query_read("SELECT
		COUNT(userid) AS total
		FROM " . TABLE_PREFIX . "user AS user
		WHERE usergroupid = ".$promotion['usergroupid']."
	");
	
	if ($vbulletin->db->num_rows($groupcountsq) > 0)
	{	
		$groupcounts = $vbulletin->db->fetch_array($groupcountsq);
	}
	
	$promotion_overview['count_users'] = vb_number_format($groupcounts['total']);


	if ($vbulletin->options['xperience_promotions_show_benefits'] AND count($oldusergrouparray) > 0)
	{
		$promotion_overview = FetchBenefits($oldusergrouparray, $promotion, $BFBo);
		$promotion_overview['promotion_benefits'] = 1;
	}

	if ($vbulletin->options['xperience_promotions_show_jumps'])
	{

		$promotionsubq = $vbulletin->db->query_read("SELECT
			p.*,
			u_to.*,
			u_to.title as to_title,
			u_fr.title as fr_title
			FROM " . TABLE_PREFIX . "xperience_promotion AS p
			LEFT JOIN " . TABLE_PREFIX . "usergroup AS u_to ON u_to.usergroupid=p.to_ug
			LEFT JOIN " . TABLE_PREFIX . "usergroup AS u_fr ON u_fr.usergroupid=p.from_ug
			WHERE from_ug=".$promotion['usergroupid']."
			ORDER BY u_fr.title, p.sortorder, p.field		
			LIMIT 0,50
		");
		
		if ($vbulletin->db->num_rows($promotionsubq) > 0)
		{	
			while ($promotionsub = $vbulletin->db->fetch_array($promotionsubq))
			{

				$promotionentry['field'] = $vbphrase['xperience_'.$promotionsub[field]]; 
				if (strlen($promotionentry['field']) < 1)
				{
					$promotionentry['field'] = $promotionsub["field"];
				}
				
				$promotionentry['value'] = vb_number_format($promotionsub['value']);
			
				$promotionentry['compare'] = $vbphrase['xperience_achievements_'.$promotionsub['compare']];
				
				$promotionentry['yours'] = vb_number_format($data[$promotionsub[field]]);
								
				$promotionentry['state_image'] = "icon_state_no.png";
				switch ($promotionsub['compare'])
				{
					case "-1":
						if ($data[$promotionsub[field]] < $promotionsub['value'])
						{
							$promotionentry['state_image'] = "icon_state_yes.png";
						}
						break;
					case "1":
						if ($data[$promotionsub[field]] > $promotionsub['value'])
						{
							$promotionentry['state_image'] = "icon_state_yes.png";
						}
						break;
					default:
						if ($data[$promotionsub[field]] == $promotionsub['value'])
						{
							$promotionentry['state_image'] = "icon_state_yes.png";
						}
						break;
				}
				$templater = vB_Template::create('xperience_promotion_overview_entry_header');
		 		$templater->register('promotionsub', $promotionsub);
				$promotion_overview['promotion_conditions'] .= $templater->render();  
				
				$templater = vB_Template::create('xperience_promotion_overview_entry');
		 		$templater->register('promotionentry', $promotionentry);
				$promotion_overview['promotion_conditions'] .= $templater->render(); 

			}
		}
	}

	$templater = vB_Template::create('xperience_promotion_overview');
	$templater->register('promotion', $promotion);
	$templater->register('promotion_overview', $promotion_overview);
	$xperience['promotions'] .= $templater->render();
			
	return $xperience['promotions'];

}



function FetchBenefits($oldusergrouparray, $promotion, $BFBo)
{

	global $vbulletin, $vbphrase;
	
	$promotion_overview = array();
	
	$promotion_benefits_exclusion = array("usergroupid", "title", "description", "usertitle", "forumpermissions");
	
	$ug_bitfield_from = array();

	$promotion_overview['promotion_benefits'] = 0;
	foreach($vbulletin->bf_ugp AS $permissiongroup => $fields)
	{
		$ug_bitfield_from["$permissiongroup"] = convert_bits_to_array($oldusergrouparray["$permissiongroup"], $fields);
	}

	$ug_bitfield_to = array();
	foreach($vbulletin->bf_ugp AS $permissiongroup => $fields)
	{
		$ug_bitfield_to["$permissiongroup"] = convert_bits_to_array($promotion["$permissiongroup"], $fields);
	}
	

	$included_permission_names = array();
	foreach ($ug_bitfield_from AS $settingname => $newvalue)
	{ 

		$oldvalue = $ug_bitfield_to[$settingname];

		foreach ($oldvalue AS $myname => $myvalue)
		{ 
			
			if ($myvalue <> $newvalue["$myname"])
			{
				$included_permission_names[] = $settingname;
				
				$promotion['translated'] = $vbphrase[$BFBo->data['ugp'][$settingname][$myname]['phrase']];
				$promotion['translated'] = preg_replace("/<dfn(.|\s)*?dfn>/", "", $promotion['translated']);
				
				
				$promotion_overview['promotion_benefits'] .= "<li><i>".$promotion['translated']."</i> set from <b>".$newvalue["$myname"]."</b> to <b>".$myvalue."</b>";

				if ($myvalue == 1)
				{
					$templater = vB_Template::create('xperience_promotion_overview_benefits_per');
					$templater->register('promotion', $promotion);
					$promotion_overview['promotion_benefits_assigned'] .= $templater->render();
				}
				else
				{
					$templater = vB_Template::create('xperience_promotion_overview_benefits_per');
					$templater->register('promotion', $promotion);
					$promotion_overview['promotion_benefits_revoked'] .= $templater->render();
				}

				$promotion_overview['promotion_benefits'] = 1;
			}
		}
	}
	$uug = $promotion['usergroupid'];
	$oldusergroupid = $oldusergrouparray['usergroupid'];

	foreach ($vbulletin->usergroupcache["$oldusergroupid"] AS $settingname => $oldvalue)
	{ 
		if (!in_array($settingname, $promotion_benefits_exclusion))
		{
			if ($vbulletin->usergroupcache["$uug"][$settingname] <> $oldvalue)
			{
				if (!in_array($settingname, $included_permission_names))
				{
					$newvalue = $vbulletin->usergroupcache["$uug"][$settingname];

					foreach ($BFBo->data['ugp'] AS $grouptitle => $perms)
					{
						foreach ($perms AS $permtitle => $permvalue)
						{ 
							if ($permtitle == $settingname)
							{
								$promotion['translated'] = $vbphrase[$BFBo->data['ugp'][$grouptitle][$settingname]['phrase']];
								$promotion['translated'] = preg_replace("/<dfn(.|\s)*?dfn>/", "", $promotion['translated']);

								break 2;
							}
						}
					}
					$promotion['oldvalue'] = vb_number_format($oldvalue);
					$promotion['newvalue'] = vb_number_format($newvalue);
					
					$templater = vB_Template::create('xperience_promotion_overview_benefits_set');
					$templater->register('promotion', $promotion);
					$promotion_overview['promotion_benefits_allowances'] .= $templater->render();
					$promotion_overview['promotion_benefits'] = 1;
				}
			}
		}
	}

return $promotion_overview;

}


function DoAchievements($user, $xperience)
{	
	global $vbulletin;
	$achievementsq = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_achievements WHERE sortorder>0 AND achievementid NOT IN(SELECT achievementid FROM " . TABLE_PREFIX . "xperience_achievements_issues WHERE userid=".$user['userid'].")");
	if ($vbulletin->db->num_rows($achievementsq) > 0)
	{
		while ($achievements = $vbulletin->db->fetch_array($achievementsq))
		{
			$achievementsfieldsq = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_achievements_fields WHERE achievementid=".$achievements['achievementid']);
			if ($vbulletin->db->num_rows($achievementsfieldsq) > 0)
			{
				$allconditionsmet = 0;
				while ($achievementsfields = $vbulletin->db->fetch_array($achievementsfieldsq))
				{

					$fielduser = str_replace("points", "count", $achievementsfields['field']);
					
					
					$conditionmet = 0;
					switch ($achievementsfields['compare'])
					{
						case "-1":
							if ($xperience[$fielduser] < $achievementsfields['value'])
							{
								$conditionmet = 1;
							}
							break;
						case "1":
							if ($xperience[$fielduser] > $achievementsfields['value'])
							{
								$conditionmet = 1;
							}
							break;
						default:
							if ($xperience[$fielduser] == $achievementsfields['value'])
							{
								$conditionmet = 1;
							}
							break;
					}
					if ($conditionmet == 0)
					{
						break;
					}
					$allconditionsmet = 1;
				}
				if ($allconditionsmet == 1)
				{
					$current_timestamp = mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"));
					$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_achievements_issues (achievementid, userid, dateline) VALUES (".$achievements['achievementid'].", ".$user['userid'].", '".$current_timestamp."')"); 
					AddNotification("xperience_achievementcount", $user['userid']);
				}
			}
		}
	}
	WriteAchievementItems($user['userid']);
}


function DoPromotions($user, $xperience)
{
	global $vbulletin;

	if (!$vbulletin->options['xperience_use_promotions']) 
	{
		return "";
	}
		
	$promotionsfieldsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_promotion AS p
		LEFT JOIN " . TABLE_PREFIX . "usergroup AS u ON u.usergroupid=p.from_ug
		WHERE from_ug=".$user['usergroupid']."
		AND sortorder>0
		ORDER BY sortorder
	");
	
	
	if ($vbulletin->db->num_rows($promotionsfieldsq) > 0)
	{
		while ($promotionsfields = $vbulletin->db->fetch_array($promotionsfieldsq)) 
		{
			$fielduser = $promotionsfields['field'];
			//str_replace("points", "count", $promotionsfields['field']);
		
			$promoted = 0;
			$demoted = 0;
			
			switch ($promotionsfields['compare'])
			{
				case "-1":
					if ($xperience[$fielduser] < $promotionsfields['value'])
					{
						$promoted = 1;
					}
					if ($xperience[$fielduser] > $promotionsfields['value'])
					{
						$demoted = 1;
					}
					break;
				case "1":
					if ($xperience[$fielduser] > $promotionsfields['value'])
					{
						$promoted = 1;
					}
					if ($xperience[$fielduser] < $promotionsfields['value'])
					{
						$demoted = 1;
					}
					break;
				default:
					if ($xperience[$fielduser] == $promotionsfields['value'])
					{
						$promoted = 1;
					}
					if ($xperience[$fielduser] !== $promotionsfields['value'])
					{
						$demoted = 1;
					}
					break;
			}
			
			//echo $user['username']."##".$fielduser."--->".$xperience[$fielduser]."----->".$promotionsfields['value']." PRO: ".$promoted." DE: ".$demoted."<br/>";
			
			 //DEMOTE NOT IMPLEMENTED AND $demoted == 0 
			if ($promoted == 0)
			{
				break;
			}
			$allconditionsmet = 1;
			if ($allconditionsmet == 1)
			{
				PromoteUser($user, $promotionsfields['from_ug'], $promotionsfields['to_ug'], $promotionsfields['promotionid'], IIF($promoted==1, 1, 2));
				return 1;
			}
		}
	}
}

function PromoteUser($user, $from_ug, $to_ug, $promotionid, $ispromote = 1)
{
	global $vbulletin;
	//build_forum_permissions();

	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_SILENT);
	$userdata->set_existing($user);
	$userdata->set('usergroupid', $to_ug);
	$userdata->set_usertitle(
		$user['customtitle'] ? $user['usertitle'] : '',
		false,
		$vbulletin->usergroupcache[$user[usergroupid]],
		($vbulletin->usergroupcache['2']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canusecustomtitle']) ? true : false,
		false
	);
	$userdata->save();
	
	if ($vbulletin->options['xperience_use_activities']) 
	{
		$current_timestamp = mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"));
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_promotion_issues (
			promotionid,
			userid,
			from_ug,
			to_ug,
			promotiontype,
			comment,
			dateline
			) VALUES (
			".$promotionid.",
			".$user['userid'].",
			".$from_ug.",
			".$to_ug.",
			".IIF($ispromote==1, 1, 2).",
			'',
			".$current_timestamp."		
			)
		");
	}
	AddNotification("xperience_promotioncount", $user['userid']);
}

function GetAchievementUsersCount($achievementid)
{
	global $vbulletin;
	$users = 0;
	$achievementcountq =$vbulletin->db->query_read("SELECT COUNT(*) AS usercount
		FROM " . TABLE_PREFIX . "xperience_achievements_issues WHERE achievementid=".$achievementid);
	
	if ($vbulletin->db->num_rows($achievementcountq) > 0)
	{
		$achievementcount = $vbulletin->db->fetch_array($achievementcountq);
		$users = $achievementcount['usercount'];
	}
	return $users;
}


function print_select($title, $name, $array, $selected = '', $htmlise = false, $size = 0, $multiple = false)
{
	global $vbulletin;

	require_once(DIR . '/includes/adminfunctions.php');

	$uniqueid = fetch_uniqueid_counter();

	$select = "<div id=\"ctrl_$name\"><select name=\"$name\" id=\"sel_{$name}_$uniqueid\" tabindex=\"1\" class=\"bginput\"" . iif($size, " size=\"$size\"") . iif($multiple, ' multiple="multiple"') . iif($vbulletin->debug, " title=\"name=&quot;$name&quot;\"") . ">\n";
	$select .= construct_select_options($array, $selected, $htmlise);
	$select .= "</select></div>\n";

	return $select;
} 

function GetActivityGAP($date_start, $date_end, $userid = 0, $limit = 50)
{
	$actives = array();
	
	global $vbulletin, $vbphrase;
	
	if (!$vbulletin->options['xperience_use_gap'])
	{
		return $actives;
	}
	
	if ($userid !== 0)
	{
		$usersql = "AND g.userid=".$userid;		
	}

	if ($vbulletin->options['xperience_use_gap']) 
	{
		
		$gapq = $vbulletin->db->query_read("SELECT
			u.username AS uname, uto.username AS utoname, g.*
			FROM " . TABLE_PREFIX . "xperience_gap AS g
			INNER JOIN " . TABLE_PREFIX . "user AS u ON g.userid=u.userid
			INNER JOIN " . TABLE_PREFIX . "user AS uto ON g.toid=uto.userid
			WHERE g.dateline>".$date_start." AND g.dateline<".$date_end."
			".$usersql." 
			ORDER BY g.dateline DESC, gapid DESC
			LIMIT ".$limit);
			
		if ($vbulletin->db->num_rows($gapq) > 0)
		{
			while ($gap = $vbulletin->db->fetch_array($gapq))
			{
				$gap['fieldname'] = $vbphrase['xperience_'.$gap[field]];
				$gap['amount'] = vb_number_format($gap['amount']);
				$gap['date'] = vbdate($vbulletin->options['dateformat'], $gap['dateline'])." ".vbdate($vbulletin->options['timeformat'], $gap['dateline']);
				$gap['detaildate'] = vbdate($vbulletin->options['timeformat'], $gap['dateline']);

				$gap['userid1'] = $gap['userid'];
				$gap['username1'] = $gap['uname'];
				
				$gap['userid2'] = $gap['toid'];
				$gap['username2'] = $gap['utoname'];

				eval('$gap_log = "' . fetch_template('xperience_gap_entry') . '";');
				$actives[] = array($gap['dateline'], $gap_log);	
			}
			
		} 
	}
	return $actives;
}

function GetActivityAll($date_start, $date_end, $do, $limit, $userid = 0, $isprofile = 0)
{
	global $vbulletin, $vbphrase, $activity, $name;

	$all = array();

	$do_promotions = false;
	$do_points = false;
	$do_achievements = false;
	$do_awards = false;
	$do_shop = false;
	$isoverview = false;
	
switch ($do)
{
	case "points":
		$name = $vbphrase['xperience_activities_points'];				
		$do_points = true;
		$level = 0;
		break;
	case "achievements":
		$name = $vbphrase['xperience_achievements'];
		$do_achievements = true;
		DeleteNotification('xperience_achievementcount', $userid);
		break;
	case "promotions":
		$name = $vbphrase['xperience_promotions'];
		$do_promotions = true;
		DeleteNotification('xperience_promotioncount', $userid);
		break;
	case "awards":
		$name = $vbphrase['xperience_awards'];
		$do_awards = true;
		DeleteNotification('xperience_awardcount', $userid);
		break;
	case "shop":
		$name = $vbphrase['xperience_shop'];
		$do_shop = true;
		break;
	default:
		$name = $vbphrase['xperience_activities_overview'];
		$do_promotions = true;
		$do_points = true;
		$do_achievements = true;
		$do_awards = true;
		$do_shop = true;
		$isoverview = true;
		$level = 2;
		DeleteNotification('xperience_promotioncount', $userid);
		DeleteNotification('xperience_awardcount', $userid);
		DeleteNotification('xperience_achievementcount', $userid);
}



	if ($do_promotions)
	{
		$arr_promotions = array();
		$arr_promotions = GetActivityPromotions($date_start, $date_end, $userid, $limit);
		if (count($arr_promotions) > 0)
		{
			$all = array_merge($all, $arr_promotions);
		}
	}
	
	if ($do_achievements)
	{
		$arr_achievements = array();
		$arr_achievements = GetActivityAchievements($date_start, $date_end, $userid, $limit);
		if (count($arr_achievements) > 0)
		{
			$all = array_merge($all, $arr_achievements);
		}
	}
	
	if ($do_points)
	{
		$arr_points = array();
		$arr_points = GetActivityActivities($date_start, $date_end, $level, $userid, $limit);
		if (count($arr_points) > 0)
		{
			$all = array_merge($all, $arr_points);
		}
		
		$arr_points_gap = array();
		$arr_points_gap = GetActivityGAP($date_start, $date_end, $userid, $limit);
		if (count($arr_points_gap) > 0)
		{
			$all = array_merge($all, $arr_points_gap);
		}
	}

	if ($do_shop)
	{
		$arr_shop = array();
		$arr_shop = GetActivityShop($date_start, $date_end, $limit);
		if (count($arr_shop) > 0)
		{
			$all = array_merge($all, $arr_shop);
		}
	}


	if ($do_awards)
	{
		$arr_awards = array();
		$arr_awards = GetActivityAwards($date_start, $date_end, $userid, $limit);
		if (count($arr_awards) > 0)
		{
			$all = array_merge($all, $arr_awards);
		}
	}
	
	$currentdate = "";
	if (count($all) > 0)
	{
		
		arsort($all); 
		
		$i=0;
		foreach ($all AS $key => $item)
		{			
			$i++;
			if ($i > $limit)
			{
				if (strlen($do) > 0)
				{
					$dotext = "&do=".$do;
				}
				$activity .= construct_phrase($vbphrase['xperience_gap_more'], $vbulletin->options['bburl']."/xperience.php?go=activities".$dotext."&year=".date("Y", $item[0])."&month=".date("n", $item[0])."&day=".date("j", $item[0]));
				$activity .= "<br/>";
				break;
			}
			else
			{
				
				
				$activities['date'] = vbdate($vbulletin->options['dateformat'], $item[0]);
				if ($currentdate <> $activities['date'])
				{
					if ($currentdate <> "")
					{
						$activity .="<br/>";
					}
					$templater = vB_Template::create('xperience_activities_dateentry');
		 			$templater->register('activities', $activities);
					$activity .= $templater->render();  
		
				}
				$currentdate = $activities['date'];

				$activity .= $item[1];
			}
		}
		$activity .= "<br/>";
		
		if ($isprofile AND !$isoverview)
		{
			$activity = construct_phrase($vbphrase['xperience_activities_for'], $name, $vbulletin->options['bburl']."/member.php?u=".$userid)."<br/><br/>".$activity;
		}

	}

	
}



function GetActivityShop($date_start, $date_end, $userid = 0, $limit = 50)
{
	$actives = array();
	
	global $vbulletin, $vbphrase;
	
	if (!$vbulletin->options['xperience_use_shop'])
	{
		return $actives;
	}	
	
	if ($userid !== 0)
	{
		$usersql = "AND (buyer=".$userid." OR userid=".$userid.")";		
	}
	
	
	$transactionq = $vbulletin->db->query_read("SELECT
		t.*,
		s.itemname,
		s.itemicon
		FROM " . TABLE_PREFIX . "xperience_shop_ta AS t
		INNER JOIN " . TABLE_PREFIX . "xperience_shop as s ON t.itemid=s.itemid
		WHERE t.dateline>".$date_start." AND t.dateline<".$date_end."
		".$usersql."
		ORDER BY dateline DESC, taid DESC
		LIMIT ".$limit);
	
	
	if ($vbulletin->db->num_rows($transactionq) > 0)
	{
			
		$TA = array();
		while ($TA = $vbulletin->db->fetch_array($transactionq))
		{

			$TA['costfield'] = $vbphrase['xperience_'.$TA[costfield]];
			
			if (strlen($TA['itemicon']) > 0)
			{
				$TA['image'] = $TA['itemicon'];	
			}
			else
			{
				$TA['image'] = $vbulletin->options['bburl']."/xperience/images/icon_item_s.png";
			}
			
			
	
			if ($TA['dateline_sell'] > 0)
			{
				$phrase = "xperience_shop_ta_selled_x";
				$TA['icon'] = "icon_item_nobuy.png";
				$TA['text'] = $vbphrase['xperience_shop_ta_sold'];
				$TA['detaildate'] = vbdate($vbulletin->options['timeformat'], $TA['dateline_sell']);
				$TA['cost'] = vb_number_format($TA['sell']);
				$myuser = fetch_userinfo($TA['buyer']);
				$TA['who'] = $myuser['username'];
				$TA['whoid'] = $TA['buyer'];
				
				eval('$transactions = "' . fetch_template('xperience_shop_ta_entry') . '";');	
				$actives[] = array($TA['dateline'], $transactions);
				
				$phrase = "xperience_shop_ta_purchased_x";
				$TA['icon'] = "icon_item_buy.png";
				$TA['detaildate'] = vbdate($vbulletin->options['timeformat'], $TA['dateline']);
				$TA['cost'] = vb_number_format($TA['costs']);
				
				eval('$transactions = "' . fetch_template('xperience_shop_ta_entry') . '";');	
				$actives[] = array($TA['dateline'], $transactions);
				
			}
			elseif ($TA['dateline_ga'] > 0)
			{
				$TA['icon'] = "icon_give_away_get.png";
				$TA['detaildate'] = vbdate($vbulletin->options['timeformat'], $TA['dateline_ga']);

				$myuser = fetch_userinfo($TA['userid']);
				$myuser_from = fetch_userinfo($TA['buyer']);
				$TA['who'] = $myuser['username'];
				$TA['whoid'] = $TA['userid'];
				$TA['from'] = $myuser_from['username'];
				$TA['fromid'] = $TA['buyer'];
				
				eval('$transactions = "' . fetch_template('xperience_shop_ta_ga_entry') . '";');	
				$actives[] = array($TA['dateline'], $transactions);

			}
			else
			{
				$phrase = "xperience_shop_ta_purchased_x";
				$TA['icon'] = "icon_item_buy.png";
				$TA['text'] = $vbphrase['xperience_shop_ta_purchased'];
				$TA['detaildate'] = vbdate($vbulletin->options['timeformat'], $TA['dateline']);
				$TA['cost'] = vb_number_format($TA['costs']);
				$myuser = fetch_userinfo($TA['buyer']);
				$TA['who'] = $myuser['username'];
				$TA['whoid'] = $TA['buyer'];
				
				eval('$transactions = "' . fetch_template('xperience_shop_ta_entry') . '";');	
				$actives[] = array($TA['dateline'], $transactions);
				
			}

		}
	}
	return $actives;

}

function GetActivityAchievements($date_start, $date_end, $userid = 0, $limit = 50)
{
	$actives = array();
	
	global $vbulletin, $vbphrase;
	
	if (!$vbulletin->options['xperience_use_achievements'])
	{
		return $actives;
	}
	
	if ($userid !== 0)
	{
		$usersql = "AND xi.userid=".$userid;
	}
	$logq =$vbulletin->db->query_read("SELECT
		xi.*,
		xa.title,
		xa.imagesmall,
		us.username
		FROM " . TABLE_PREFIX . "xperience_achievements_issues AS xi
		INNER JOIN " . TABLE_PREFIX . "user AS us ON us.userid=xi.userid
		INNER JOIN " . TABLE_PREFIX . "xperience_achievements AS xa ON xa.achievementid=xi.achievementid
		WHERE xi.dateline>".$date_start." AND xi.dateline<".$date_end." 
		".$usersql."
		ORDER BY xi.dateline DESC, issueid DESC
		LIMIT ".$limit);

	if ($vbulletin->db->num_rows($logq) > 0)
	{
		while ($log = $vbulletin->db->fetch_array($logq))
		{
			
			$log['image'] = "icon_achievements_got.png";

			if (strlen($log['imagesmall']) > 0)
			{
				$log['achievementimage'] = $log['imagesmall'];
			}
			else
			{
				$log['achievementimage'] = $vbulletin->options['bburl']."/xperience/images/icon_achievements_default.png";
			}

			$log['phrase'] = construct_phrase($vbphrase['xperience_achievements_g'], $log['userid'], $log['username'], $log['achievementimage'], $log['title']); 

			$log['detaildate'] = vbdate($vbulletin->options['timeformat'], $log['dateline']);			
			$templater = vB_Template::create('xperience_achievements_logbit');
		 	$templater->register('log', $log);
			$logbits = $templater->render();  
			$actives[] = array($log['dateline'], $logbits);	
		}
		
	}

		return $actives;

}



function GetActivityAwards($date_start, $date_end, $userid = 0, $limit = 50)
{
	$actives = array();
	
	global $vbulletin, $vbphrase;
	
	if (!$vbulletin->options['xperience_use_awards'])
	{
		return $actives;
	}
	
	if ($userid !== 0)
	{
		$usersql = "AND xi.userid=".$userid;
	}
	$awlogs =$vbulletin->db->query_read("SELECT
		xi.*,
		xa.awardtitle,
		xa.awardname,
		xa.awardurl,
		us.username
		FROM " . TABLE_PREFIX . "xperience_award_issues AS xi
		INNER JOIN " . TABLE_PREFIX . "user AS us ON us.userid=xi.userid
		INNER JOIN " . TABLE_PREFIX . "xperience_awards AS xa ON xa.awardid=xi.awardid
		WHERE xi.dateline>".$date_start." AND xi.dateline<".$date_end." 
		".$usersql."
		ORDER BY xi.dateline DESC, issueid DESC
		LIMIT ".$limit);

	if ($vbulletin->db->num_rows($awlogs) > 0)
	{
		while ($awlog = $vbulletin->db->fetch_array($awlogs))
		{
			if ($awlog['dateline_out'] > 0)
			{
				$awlog['awphrase'] = construct_phrase($vbphrase['xperience_award_r'], $awlog['userid'], $awlog['username'], $awlog['awardurl'], $awlog['awardtitle']); 
				$awlog['dateline'] -= 1;
				$awlog['awimage'] = "icon_award_returned.png";
			}
			else
			{
				$awlog['awphrase'] = construct_phrase($vbphrase['xperience_award_g'], $awlog['userid'], $awlog['username'], $awlog['awardurl'], $awlog['awardtitle']); 
				$awlog['awimage'] = "icon_award_got.png";
			}

			if (strlen($awlog['awardurl']) > 0)
			{
				$awlog['image'] = $awlog['awardurl'];
			}
			else
			{
				$awlog['image'] = $vbulletin->options['bburl']."/xperience/icons/default_16.png";
			}

			$awlog['detaildate'] = vbdate($vbulletin->options['timeformat'], $awlog['dateline']);			


			$templater = vB_Template::create('xperience_awards_logbit');
		 	$templater->register('awlog', $awlog);
			$awlogbits = $templater->render();  
			$actives[] = array($awlog['dateline'], $awlogbits);	
		}
		
	}

		return $actives;

}



function GetActivityPromotions($date_start, $date_end, $userid = 0, $limit = 50)
{
	$actives = array();
	
	global $vbulletin, $vbphrase;

	if (!$vbulletin->options['xperience_use_promotions'])
	{
		return $actives;
	}
	
	if ($userid !== 0)
	{
		$usersql = "AND l.userid=".$userid;
	}

	$promotionq = $vbulletin->db->query_read("SELECT
		g.usertitle, g.title, u.username, l.*
		FROM " . TABLE_PREFIX . "xperience_promotion_issues AS l
		INNER JOIN " . TABLE_PREFIX . "user AS u ON u.userid=l.userid
		INNER JOIN " . TABLE_PREFIX . "usergroup AS g ON g.usergroupid=l.to_ug
		WHERE l.dateline>".$date_start." AND l.dateline<".$date_end."
		".$usersql."
		ORDER BY dateline DESC, promotionid DESC
		LIMIT ".$limit);

	if ($vbulletin->db->num_rows($promotionq) > 0)
	{	
		$currentdate = "";
		while ($promotion = $vbulletin->db->fetch_array($promotionq))
		{
			if (strlen($promotion['usertitle'])>1)
			{
				$promotion['usergroup'] = $promotion['usertitle'];
			} else {
				$promotion['usergroup'] = $promotion['title'];
			}
			$promotion['detaildate'] = vbdate($vbulletin->options['timeformat'], $promotion['dateline']);
			$promotion['date'] = vbdate($vbulletin->options['dateformat'], $promotion['dateline']);

			if ($promotion['promotiontype'] == 2)
			{
				$promotion['phrase'] = construct_phrase($vbphrase['xperience_demoted_x'], $promotion['userid'], $promotion['username'], $promotion['detaildate'], $promotion['usergroup']); 
				$promotion['icon'] = "icon_demoted.png";
			} else {
				$promotion['phrase'] = construct_phrase($vbphrase['xperience_promoted_x'], $promotion['userid'], $promotion['username'], $promotion['detaildate'], $promotion['usergroup']); 
				$promotion['icon'] = "icon_promoted.png";				
			}
			

			$templater = vB_Template::create('xperience_promotion_entry');
		 	$templater->register('promotion', $promotion);
			$activityentry = $templater->render();  

			$actives[] = array($promotion['dateline'], $activityentry);			
		}
		return $actives;
	}
	
}


function GetActivityActivities($date_start, $date_end, $level, $userid = 0, $limit = 50)
{
	$actives = array();
	
	global $vbulletin, $vbphrase;
	
	if ($userid !== 0)
	{
		$usersql = "AND s.userid=".$userid;
	}
	
	$activitiesq = $vbulletin->db->query_read("SELECT
		u.username, s.* 
		FROM " . TABLE_PREFIX . "xperience_stats_changes AS s
		INNER JOIN " . TABLE_PREFIX . "user AS u ON u.userid=s.userid
		WHERE s.ismajor = ".$level."
		AND s.dateline>".$date_start." AND s.dateline<".$date_end."
		$usersql
		ORDER BY s.dateline DESC, s.statsid DESC
		LIMIT ".$limit);

	if ($vbulletin->db->num_rows($activitiesq) > 0)
	{
		while ($activities = $vbulletin->db->fetch_array($activitiesq))
		{

			$earn['detaildate'] = vbdate($vbulletin->options['timeformat'], $activities['dateline']);
			$activities['date'] = vbdate($vbulletin->options['dateformat'], $activities['dateline']);
			$activities['fieldname'] = $vbphrase['xperience_'.$activities[field]];
			if (strlen($activities['fieldname']) == 0)
			{
				$activities['fieldname'] = $activities['field'];
			} 
			$activities['points'] = vb_number_format($activities['difference']);

			$earn['points'] = construct_phrase($vbphrase['xperience_activity_points'], $activities['difference'], $activities['fieldname']); 
			
			
			if ($activities['difference'] > 0)
			{
 				$earn['phrase'] = construct_phrase($vbphrase['xperience_activity_x_earn'], $activities['userid'], $activities['username'], $earn['points'] );
				$earn['image'] = "icon_points_earn.png";
			}
			else
			{
				$earn['phrase'] = construct_phrase($vbphrase['xperience_activity_x_lose'], $activities['userid'], $activities['username'], $earn['points'] );
				$earn['image'] = "icon_points_lose.png";
			}
			
			$templater = vB_Template::create('xperience_activities_entry');
		 	$templater->register('earn', $earn);
			$activityentry = $templater->render();  
			
							
			$actives[] = array($activities['dateline'], $activityentry);
	
			
		}
			return $actives;
	}
	
}


function GetProfileFields()
{
	global $vbulletin;
	
	$profilefieldsq =$vbulletin->db->query_read("SELECT 
		profilefieldid
		FROM " . TABLE_PREFIX . "profilefield
		WHERE (editable=1 OR editable=2) AND def=0
		");
	
	$profilefields = array();
	if ($vbulletin->db->num_rows($profilefieldsq) > 0) 
	{
		while ($profilefield = $vbulletin->db->fetch_array($profilefieldsq))
		{
			$profilefields[] = $profilefield['profilefieldid'];
		}
	} 

	return $profilefields;

}

function DeleteNotification($column, $userid)
{
	global $vbulletin;
	if ($userid == $vbulletin->userinfo['userid'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET ".$column."=0 WHERE userid=".$userid);
	}
}

function AddNotification($column, $userid)
{
	global $vbulletin;
	
	if ($vbulletin->options['xperience_notifications']) 
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET ".$column."=+1 WHERE userid=".$userid);
	}
}


function ValidateActivity()
{
	global $vbulletin;
	

	$valactq = $vbulletin->db->query_read("SELECT
		userid
		FROM " . TABLE_PREFIX . "xperience_stats
		WHERE points_user_activity > 99
		ORDER BY points_post_avg DESC
		");
		
	if ($vbulletin->db->num_rows($valactq) > 1)
	{
		$firstrow = $vbulletin->db->fetch_array($valactq);
		
		$impact = 99.9;		
		while ($valact = $vbulletin->db->fetch_array($valactq))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_stats 
				SET
				points_user_activity=".$impact."
				WHERE userid=".$valact['userid']);
			
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
				SET
				xperience_ppd=".$impact."
				WHERE userid=".$valact['userid']);
				$impact -= 0.1;
				if ($impact < 99)
				{
					$impact = 99;
				}
		}
	}
	
		$valactq = $vbulletin->db->query_read("SELECT
		userid
		FROM " . TABLE_PREFIX . "xperience_stats
		WHERE points_user_activity30 > 99
		ORDER BY points_post_avg DESC
		");
		
	if ($vbulletin->db->num_rows($valactq) > 1)
	{
		$firstrow = $vbulletin->db->fetch_array($valactq);
		
		$impact = 99.9;		
		while ($valact = $vbulletin->db->fetch_array($valactq))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_stats 
				SET
				points_user_activity30=".$impact."
				WHERE userid=".$valact['userid']);
			
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
				SET
				xperience_ppd30=".$impact."
				WHERE userid=".$valact['userid']);
				$impact -= 0.1;
				if ($impact < 99)
				{
					$impact = 99;
				}
		}
	}
	
		$valactq = $vbulletin->db->query_read("SELECT
		userid
		FROM " . TABLE_PREFIX . "xperience_stats
		WHERE points_user_activity7 > 99
		ORDER BY points_post_avg DESC
		");
		
	if ($vbulletin->db->num_rows($valactq) > 1)
	{
		$firstrow = $vbulletin->db->fetch_array($valactq);
		
		$impact = 99.9;		
		while ($valact = $vbulletin->db->fetch_array($valactq))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_stats 
				SET
				points_user_activity7=".$impact."
				WHERE userid=".$valact['userid']);
			
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
				SET
				xperience_ppd7=".$impact."
				WHERE userid=".$valact['userid']);
				$impact -= 0.1;
				if ($impact < 99)
				{
					$impact = 99;
				}
		}
	}
}

function GetDayDiff($date1, $date2)
{
	$dateDiff = $date1 - $date2;
	$days = floor($dateDiff/(60*60*24));
	return $days;
}


function AddTransaction($transaction, $tatype)
{
	global $vbulletin, $vbphrase, $aTA;
	
	$taid = $transaction['taid'];

	
	$aTA['$taid']['ID'] = $taid;
	$aTA['$taid']['type'] = $tatype;
	$aTA['$taid']['item'] = $transaction['itemname'];
	$aTA['$taid']['itemid'] = $transaction['itemid'];
	$aTA['$taid']['cost'] = "-".vb_number_format($transaction['costs']);
	$aTA['$taid']['costfield'] = $vbphrase['xperience_'.$transaction[costfield]];
		
	switch ($tatype)
	{
		case 1:
			$aTA['$taid']['icon'] = "icon_item_nobuy.png";
			$aTA['$taid']['text'] = $vbphrase['xperience_shop_ta_sold'];
			$aTA['$taid']['date'] = vbdate($vbulletin->options['dateformat'], $transaction['dateline_sell'])." ".vbdate($vbulletin->options['timeformat'], $transaction['dateline_sell']);
			$aTA['$taid']['cost'] = vb_number_format($transaction['sell']);
			$aTA['$taid']['who'] = $vbphrase['xperience_shop_name'];
			$aTA['$taid']['whoid'] = 0;
			break;
		case 2:
			$aTA['$taid']['icon'] = "icon_give_away.png";
			$aTA['$taid']['text'] = $vbphrase['xperience_shop_ta_ga'];
			$aTA['$taid']['date'] = vbdate($vbulletin->options['dateformat'], $transaction['dateline_ga'])." ".vbdate($vbulletin->options['timeformat'], $transaction['dateline_ga']);
			$myuser = fetch_userinfo($transaction['userid']);
			$aTA['$taid']['who'] = $myuser['username'];
			$aTA['$taid']['whoid'] = $transaction['userid'];
			break;
		case 3:
			$aTA['$taid']['icon'] = "icon_give_away_get.png";
			$aTA['$taid']['text'] = $vbphrase['xperience_shop_ta_ga_received'];
			$aTA['$taid']['date'] = vbdate($vbulletin->options['dateformat'], $transaction['dateline_ga'])." ".vbdate($vbulletin->options['timeformat'], $transaction['dateline_ga']);
			$myuser = fetch_userinfo($transaction['buyer']);
			$aTA['$taid']['who'] = $myuser['username'];
			$aTA['$taid']['whoid'] = $transaction['buyer'];
			break;
		default:
			$aTA['$taid']['icon'] = "icon_item_buy.png";
			$aTA['$taid']['text'] = $vbphrase['xperience_shop_ta_purchased'];
			$aTA['$taid']['date'] = vbdate($vbulletin->options['dateformat'], $transaction['dateline'])." ".vbdate($vbulletin->options['timeformat'], $transaction['dateline']);
			$aTA['$taid']['who'] = $vbphrase['xperience_shop_name'];
			$aTA['$taid']['whoid'] = 0;
			break;
	}
	
}

function DoesColumnExists($table, $field)
{
	global $vbulletin;
	return ($vbulletin->db->num_rows($vbulletin->db->query_read("SHOW COLUMNS FROM `" . TABLE_PREFIX .$table."` LIKE '".$field."'"))> 0);
}

function DoesTableExists($tablename)
{
	global $vbulletin;
	
	$istable = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . $tablename."'");
	if ($vbulletin->db->num_rows($istable) > 0) 
	{	
		return 1;
	}
	return 0;
}



function ResolveAssociation($option_name, $tablecheck = "", $column_name = "")
{
	global $vbulletin, $settingphrase;
		
	if ($vbulletin->options["$option_name"] == 0) 
	{
		return "";
	}

	if (strlen($tablecheck) > 0)
	{
		$istable = $vbulletin->db->query_read("SHOW TABLES LIKE '" . TABLE_PREFIX . $tablecheck."'");
		if ($vbulletin->db->num_rows($istable) == 0)
		{
			return "";
		}
	}

	switch ($type)
	{
		case "1":
			$count_sum = "Sum";
			break;
		default:
			$count_sum = "Count";
			break;
	}
	
	
	$phrase = "setting_".$option_name."_title";
	$xperience['name'] = $settingphrase["$phrase"];
	
	$descphrase = "setting_".$option_name."_desc";
	$xperience['description']= $settingphrase["$descphrase"];
	
	$xperience['value'] = $vbulletin->options["$option_name"];
	
	$yours = "?";
	if (strlen($column_name) > 0)
	{
		$yoursaq = $vbulletin->db->query_read("SELECT ".$column_name." AS C FROM " . TABLE_PREFIX . "xperience_stats WHERE userid=".$vbulletin->userinfo['userid']);
		if ($vbulletin->db->num_rows($yoursq) == 0)
		{
			$yoursa = $vbulletin->db->fetch_array($yoursaq);
			$xperience['yours'] = vb_number_format($yoursa['C']);
		}
	}
		
		
	$templater = vB_Template::create('xperience_earn_entry');
 	$templater->register('xperience', $xperience);
 	$xperience_earn_entry = $templater->render();  
	return $xperience_earn_entry;
}


function WriteAward($award, $userid)
{
	global $vbulletin;
	
	$timestamp = mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"));

	if (!verify_id("user", $userid, false, false))
	{
		return "";
	}
	
	if (!is_array($award))
	{
		return "";
	}

	$awardissues = $vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_award_issues
		WHERE dateline_out=0 AND userid=".$userid." AND awardid=".$award['awardid']);  
	
	if ($vbulletin->db->num_rows($awardissues) == 0)
	{
		$oldawardissues = $vbulletin->db->query_read("SELECT
			*
			FROM " . TABLE_PREFIX . "xperience_award_issues
			WHERE dateline_out=0 AND awardid=".$award['awardid']." ORDER BY dateline_in DESC, issueid DESC");
			
		if ($vbulletin->db->num_rows($oldawardissues) > 0)
		{
			while ($oldawardissue = $vbulletin->db->fetch_array($oldawardissues))
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_award_issues SET dateline='".$timestamp."', dateline_out='".$timestamp."' WHERE issueid=".$oldawardissue['issueid']."");
				AddNotification("xperience_awardcount", $oldawardissue['userid']);
			}
		}
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_award_issues (awardid, userid, dateline, dateline_in) VALUES (".$award['awardid'].", ".$userid.", '".$timestamp."', '".$timestamp."')"); 
		AddNotification("xperience_awardcount", $userid);
	}




	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
		SET
		xperience_awards=CONCAT('".addslashes($award['awardid'])."|".addslashes($award['awardname'])."|".addslashes($award['awardtitle'])."|".addslashes($award['awardurl'])."|".addslashes($award['awardbigurl'])."', ',', xperience_awards)
		WHERE userid=".$userid);
}

function WriteShopItem($item, $userid)
{
		global $vbulletin;

		if (strlen($item['itemicon']) < 3)
		{
			$item['itemicon'] = $vbulletin->options['bburl']."/xperience/images/icon_item_s.png";
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
			SET
			xperience_shopitems=CONCAT('".addslashes($item['itemid'])."|".addslashes($item['cnt_items'])."|".addslashes($item['itemname'])."|".addslashes($item['itemicon'])."', ',', xperience_shopitems)
			WHERE userid=".$userid);
}

function WriteAchievementItems($userid)
{
	global $vbulletin;
	
	if ($vbulletin->options['xperience_achievements_postbit'] == 5)
	{
		return;
	}
	
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
		SET
		xperience_achievements=''
		WHERE userid=".$userid);
	
	$achievementsq =$vbulletin->db->query_read("SELECT
		a.achievementid,
		a.title,
		a.imagesmall,
		a.imagebig
		FROM " . TABLE_PREFIX . "xperience_achievements_issues AS i
		INNER JOIN " . TABLE_PREFIX . "xperience_achievements AS a ON a.achievementid=i.achievementid
		WHERE i.userid=".$userid."
		ORDER BY i.dateline
		LIMIT 0,".$vbulletin->options['xperience_achievements_items']."
	");

	if ($vbulletin->db->num_rows($achievementsq) > 0)
	{
		while ($achievements = $vbulletin->db->fetch_array($achievementsq))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
				SET
				xperience_achievements=CONCAT('".addslashes($achievements['achievementid'])."|".addslashes($achievements['title'])."|".addslashes($achievements['imagesmall'])."|".addslashes($achievements['imagebig'])."', ',', xperience_achievements)
				WHERE userid=".$userid);
		}			
	}	
}


function WriteShopItems($userinfo)
{
	global $vbulletin;
	
	if ($vbulletin->options['xperience_shop_postbit'] == 0)
	{
		return;
	}
	
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
	SET
	xperience_shopitems=''
	WHERE userid=".$userinfo['userid']);
	
	$itemsaq =$vbulletin->db->query_read("SELECT
		COUNT(t.itemid) as cnt_items, s.itemname, s.itemicon, s.itemid
		FROM " . TABLE_PREFIX . "xperience_shop_ta as t
		INNER JOIN " . TABLE_PREFIX . "xperience_shop as s ON s.itemid=t.itemid
		WHERE sell=0
		AND ((t.buyer=".$userinfo['userid']." AND t.userid=0) OR (t.userid=".$userinfo['userid']."))
		GROUP BY t.itemid
		ORDER BY dateline DESC
		LIMIT ".$vbulletin->options['xperience_shop_postbit']);

	if ($vbulletin->db->num_rows($itemsaq) > 0)
	{
		while ($itemsa = $vbulletin->db->fetch_array($itemsaq))
		{
			WriteShopItem($itemsa, $userinfo['userid']);
		}			
	}	
}

function GetShopItems($userinfo)
{
	global $vbulletin, $vbphrase;

	$xperience_items = explode(",", $userinfo['xperience_shopitems']);

	foreach($xperience_items AS $itemk => $iteme)
	{ 
		$itemi = explode("|", $iteme);
		$itemid = $itemi[0];
		if (is_numeric($itemid))
		{
			$itemcount = $itemi[1];
			$itemname = $itemi[2];
			$itemicon = $itemi[3];
			
			eval('$items .= " ' . fetch_template('xperience_shop_item_p') . '";');
			
			$mycount++;
			if ($mycount > $vbulletin->options['xperience_shop_postbit_break'] - 1)
			{
				$items .= "<br/>";
				$mycount = 0;
			}

		}
	}

	return $items;
}

function GetAwards($MyAwards, $withtitle = false) 
{
	global $vbulletin, $stylevar, $vbphrase;

	if (strlen($MyAwards) > 3)
	{

		$xperience_awards = explode(",", substr($MyAwards, 0, strlen($MyAwards)-1));
	
		foreach($xperience_awards AS $awardk => $awarde) 
		{
			$awardi = explode("|", $awarde);
			$awardid = $awardi[0];
			if (is_numeric($awardid))
			{
	
				$awardtitle = $awardi[2];
				$awardurl = $awardi[3];
				$awardbigurl = $awardi[4];
	
				if (strlen($awardbigurl) > 0 AND $withtitle)
				{
					$awards .= '<img class="inlineimg" border="0" width="32" height="32" border="0" src="'.$awardbigurl.'" title="'.$awardtitle.'" />';
					$usebig = true;
				}
									
				if (strlen($awardurl) > 0 AND !$usebig)
				{
					$awards .= '<img class="inlineimg" border="0" width="16" height="16" border="0" src="'.$awardurl.'" title="'.$awardtitle.'" />';
					$usesmall = true;
				}
	
				if (!$usesmall AND !$usebig) 
				{
					$awards .= '<img class="inlineimg" border="0" src="'.$vbulletin->options['bburl'].'/xperience/icons/default_16.png" title="'.$awardtitle.'" />';
				}
				if ($withtitle)
				{
					$awards .= " ".$awardtitle."<br/>";
				}
				
			}
		}
	}
	return $awards;
}

function GetAchievements($MyAchievements, $withtitle = false) 
{
	global $vbulletin, $stylevar, $vbphrase;

	if (strlen($MyAchievements) > 3)
	{

		$xperience_achievements = explode(",", substr($MyAchievements, 0, strlen($MyAchievements)-1));
	
		foreach($xperience_achievements AS $achievementk => $achievemente) 
		{
			$achievementi = explode("|", $achievemente);
			$achievementid = $achievementi[0];
			if (is_numeric($achievementid))
			{
	
				$achievementtitle = $achievementi[1];
				$achievementurl = $achievementi[2];
				$achievementbigurl = $achievementi[3];
	
				if (strlen($achievementbigurl) > 0 AND $withtitle)
				{
					$achievements .= '<img class="inlineimg" border="0" width="32" height="32" border="0" src="'.$achievementbigurl.'" title="'.$achievementtitle.'" />';
					$usebig = true;
				}
									
				if (strlen($achievementurl) > 0 AND !$usebig)
				{
					$achievements .= '<img class="inlineimg" border="0" width="16" height="16" border="0" src="'.$achievementurl.'" title="'.$achievementtitle.'" />';
					$usesmall = true;
				}
	
				if (!$usesmall AND !$usebig) 
				{
					$achievements .= '<img class="inlineimg" border="0" border="0" src="'.$vbulletin->options['bburl'].'/xperience/icons/default_16.png" title="'.$achievementtitle.'" />';
				}
				if ($withtitle)
				{
					$achievements .= " ".$achievementtitle."<br/>";
				}
				
			}
		}
	}
	return $achievements;
}

function GetAvatar($userinfo)
{
	global $vbulletin;
	
	$avatarurl = $userinfo['avatarurl'];
	
	if ($userinfo['avatarid']) {
		$avatarurl = $userinfo['avatarpath'];
	} else 	{
		if ($userinfo['hascustomavatar'] AND $vbulletin->options['avatarenabled']) 	{
			if ($vbulletin->options['usefileavatar']) 	{
				$avatarurl = $vbulletin->options['avatarurl'] . "/avatar$userinfo[userid]_$userinfo[avatarrevision].gif";
			} else 	{
				$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . "u=$userinfo[userid]&amp;dateline=$userinfo[avatardateline]";
			}
		} else {
			if (!empty($userinfo['avatarurl'])) {
				$avatarurl = $userinfo['avatarurl'];
			} else {
				$avatarurl = '';
			}
		}
	}

return $avatarurl;
} 


function GetItemCount($catid)
{
	global $vbulletin;
	$count_items = 0;
	if (strlen($catid > 0))
	{
		$itemsq = $vbulletin->db->query_read("SELECT COUNT(itemid) as c_items FROM " . TABLE_PREFIX . "xperience_shop WHERE catid=".$catid);
	
		if ($vbulletin->db->num_rows($itemsq) > 0)
		{
			$items = $vbulletin->db->fetch_array($itemsq);
			$count_items = $items['c_items'];
		}
	}
	return $count_items;
}

function construct_xp_categories($parentid, $current, $prechars = '') 
{
	global $vbulletin, $vbphrase, $stylevar;
	$category['prechars'] .= " &nbsp; &nbsp; ";
	$catq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_shop_cat WHERE catstatus<>0 AND catparent=".$parentid." ORDER BY catstatus");
	if ($vbulletin->db->num_rows($catq) > 0)
	{
		while ($cat = $vbulletin->db->fetch_array($catq))
		{
				global $bgclass, $altbgclass;
				exec_switch_bg(); 
				
				if ($current == $cat['catid'])
				{
					$category['icon'] = "icon_cat_opened.png";
				}
				else
				{
					$category['icon'] = "icon_cat_closed.png";
				}
				$category['count_items'] = GetItemCount($cat['catid']);
				
				$templater = vB_Template::create('xperience_shop_cat');
 				$templater->register('category', $category);
 				$templater->register('cat', $cat);
 				$categories .= $templater->render();  
				$categories .= construct_xp_categories($cat['catid'], $current, $category['prechars']);
		}
		
	}
	return $categories;
}

function CheckBuyConditions($itemsa, $userstats, $getphrase = false)
{
	global $vbulletin;
	
	$allow = true;
	$buyphrase = "xperience_shop_buy";
	
	if ($itemsa['quantity'] == 0)
	{
		$allow = false;
		$buyphrase = "xperience_shop_err_qnt";
	}
	
	if ($itemsa['costs'] > $userstats["$itemsa[costfield]"])
	{
		$allow = false;
		$buyphrase = "xperience_shop_err_cost";
	}
	
	if (!$vbulletin->options['xperience_shop_allow_multi'])
	{
		$userq =$vbulletin->db->query_read("SELECT itemid FROM " . TABLE_PREFIX . "xperience_shop_ta WHERE itemid=".$itemsa['itemid']." AND sell=0 AND buyer=".$userstats['userid']);
		if ($vbulletin->db->num_rows($userq) > 0)
		{
			$allow = false;
			$buyphrase = "xperience_shop_err_own";
		}
	}
		
	if ($getphrase) 
	{
		return $buyphrase;
	} else {
		return $allow;
	}
	
}


function fetch_xperience($userid)
{
	global $vbulletin;
	
	$userstats = array();
	$userq = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_stats WHERE userid=".$userid);
	if ($vbulletin->db->num_rows($userq) > 0)
	{
		$userstats = $vbulletin->db->fetch_array($userq);
	}
	else
	{
		$userstats['userid'] = $userid;
	}
	
	return $userstats;
}


function fetch_statistics($fetchthis)
{
	global $vbulletin, $vbphrase;
	global $bgclass, $altbgclass;
	
	$optionsq =$vbulletin->db->query_read("SHOW COLUMNS
		FROM " . TABLE_PREFIX . "xperience_stats LIKE 'points_".$fetchthis."%'");
					
	if ($vbulletin->db->num_rows($optionsq) > 0)
	{

		
		while ($options = $vbulletin->db->fetch_array($optionsq)) 
		{
			$xperience['statsname'] = $vbphrase['xperience_'.$options[Field]];

			//
			$getstatsq =$vbulletin->db->query_read("SELECT
				u.userid, u.username, s.".$options['Field']." AS cnt_count
				FROM " . TABLE_PREFIX . "xperience_stats AS s
				INNER JOIN " . TABLE_PREFIX . "user AS u ON u.userid = s.userid
				WHERE s.".$options['Field']." <> 0
				ORDER BY s.".$options['Field']." DESC, s.points_xperience DESC
				LIMIT ".$vbulletin->options['xperience_stats_maxtop']);

			if ($vbulletin->db->num_rows($getstatsq) > 0)
			{

				$xperience['statscontent'] = '';
				$entrycounter = 0;
				while ($getstats = $vbulletin->db->fetch_array($getstatsq)) 
				{
					$entrycounter++;
					$getstats['cnt_count'] = vb_number_format($getstats['cnt_count']);
					$templater = vB_Template::create('xperience_stats_entry');
 					$templater->register('getstats', $xperience);
 					$xperience['statscontent'] .= $templater->render();  
				}
				
				if ($entrycounter < $vbulletin->options['xperience_stats_maxtop'] )
				{
					for($i=$entrycounter; $i <= $vbulletin->options['xperience_stats_maxtop'] - 1; $i++)
					{
					$templater = vB_Template::create('xperience_stats_entry_empty');
 					$templater->register('xperience', $xperience);
 					$xperience['statscontent'] .= $templater->render(); 
					}
				}
				
				$columncounter++;

				$templater = vB_Template::create('xperience_stats_entries');
				$templater->register('getstats', $xperience);
				$stats .= $templater->render(); 
				if ($columncounter > 4)
				{
					$columncounter = 0;
					$stats .="</tr><tr>";
				}
			}
		}
	}

	if ($columncounter > 0 AND $columncounter < 5 )
	{
		for($i=$columncounter; $i <= 4; $i++)
		{
			$templater = vB_Template::create('xperience_stats_entries_empty');
			$stats .= $templater->render(); 
		}
	}
	return $stats;
}
?>